/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;

public class TagIngredientJS
implements IngredientJS {
    public static Context context = Context.EMPTY;
    private final TagKey<Item> tag;
    private ContextualResult cachedResult;

    public static TagIngredientJS createTag(String tag) {
        return new TagIngredientJS(tag).validateTag();
    }

    public static void resetContext() {
        context = Context.EMPTY;
    }

    private TagIngredientJS(String t) {
        this.tag = Tags.item(UtilsJS.getMCID(t));
    }

    public ResourceLocation getTag() {
        return this.tag.f_203868_();
    }

    public Collection<Holder<Item>> getHolders() {
        if (this.cachedResult == null || this.cachedResult.context != context) {
            this.cachedResult = new ContextualResult(context, Sets.newLinkedHashSet(context.getTag(this.tag)));
        }
        return this.cachedResult.holders();
    }

    @Override
    public boolean test(ItemStackJS stack) {
        return !stack.isEmpty() && this.testVanilla(stack.getItemStack());
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return context.areTagsBound() ? stack.m_204117_(this.tag) : this.getHolders().contains(stack.m_41720_().m_204114_());
    }

    @Override
    public boolean testVanillaItem(Item item) {
        if (item == Items.f_41852_) {
            return false;
        }
        Holder.Reference holder = item.m_204114_();
        return context.areTagsBound() ? holder.m_203656_(this.tag) : this.getHolders().contains(holder);
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        return (Set)Util.m_137469_(new LinkedHashSet(), set -> {
            for (Holder<Item> holder : this.getHolders()) {
                set.add(new ItemStackJS(new ItemStack(holder)));
            }
        });
    }

    @Override
    public Set<Item> getVanillaItems() {
        return (Set)Util.m_137469_(new LinkedHashSet(), set -> {
            for (Holder<Item> holder : this.getHolders()) {
                set.add((Item)holder.m_203334_());
            }
        });
    }

    @Override
    public ItemStackJS getFirst() {
        Iterator<Holder<Item>> iterator = this.getHolders().iterator();
        if (iterator.hasNext()) {
            Holder<Item> holder = iterator.next();
            return new ItemStackJS(new ItemStack(holder));
        }
        return ItemStackJS.EMPTY;
    }

    @Override
    public boolean isEmpty() {
        return !this.getHolders().iterator().hasNext();
    }

    public String toString() {
        return "'#%s'".formatted(this.getTag());
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("tag", this.getTag().toString());
        return json;
    }

    @Override
    public boolean anyStackMatches(IngredientJS ingredient) {
        if (ingredient instanceof TagIngredientJS) {
            TagIngredientJS tagIngredient = (TagIngredientJS)ingredient;
            if (this.tag.equals(tagIngredient.tag)) {
                return true;
            }
        }
        return IngredientJS.super.anyStackMatches(ingredient);
    }

    private TagIngredientJS validateTag() {
        if (RecipeJS.itemErrors && context.isEmpty(this.tag)) {
            throw new RecipeExceptionJS("Tag %s doesn't contain any items!".formatted(this)).error();
        }
        return this;
    }

    @Override
    public Ingredient createVanillaIngredient() {
        return Ingredient.m_204132_(this.tag);
    }

    public static interface Context {
        public static final Context EMPTY = new Context(){

            @Override
            public boolean isEmpty(TagKey<Item> tag) {
                return true;
            }

            @Override
            public boolean areTagsBound() {
                return false;
            }

            @Override
            public Iterable<Holder<Item>> getTag(TagKey<Item> tag) {
                KubeJS.LOGGER.warn("Tried to get tag {} from an empty tag context!", (Object)tag.f_203868_());
                return List.of();
            }
        };
        public static final Context REGISTRY = new Context(){

            @Override
            public boolean isEmpty(TagKey<Item> tag) {
                return Registry.f_122827_.m_203431_(tag).isEmpty();
            }

            @Override
            public boolean areTagsBound() {
                return true;
            }

            @Override
            public Iterable<Holder<Item>> getTag(TagKey<Item> tag) {
                return Registry.f_122827_.m_206058_(tag);
            }
        };

        public boolean isEmpty(TagKey<Item> var1);

        public boolean areTagsBound();

        public Iterable<Holder<Item>> getTag(TagKey<Item> var1);

        public static Context usingResult(final TagManager.LoadResult<Item> manager) {
            return new Context(){

                @Override
                public boolean isEmpty(TagKey<Item> tag) {
                    return Iterables.isEmpty(this.getTag(tag));
                }

                @Override
                public boolean areTagsBound() {
                    return false;
                }

                @Override
                public Iterable<Holder<Item>> getTag(TagKey<Item> tag) {
                    return manager.f_203929_().getOrDefault(tag.f_203868_(), Tag.m_203861_()).m_6497_();
                }
            };
        }
    }

    public record ContextualResult(Context context, Collection<Holder<Item>> holders) {
    }
}

